##  Lattice Boltzmann sample, written in Ruby
##
##  Main author: Jean-Luc Falcone
##  Co-author: Jonas Latt
##  Copyright (C) 2006 University of Geneva
##  Address: Jean-Luc Falcone, Rue General Dufour 24,
##           1211 Geneva 4, Switzerland 
##
##  This program is free software; you can redistribute it and/or
##  modify it under the terms of the GNU General Public License
##  as published by the Free Software Foundation; either version 2
##  of the License, or (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##  GNU General Public License for more details.
##
##  You should have received a copy of the GNU General Public 
##  License along with this program; if not, write to the Free 
##  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
##  Boston, MA  02110-1301, USA.
##

module LB

# Mixin methods/constants that are useful for D2Q9 BGK dynamics
module D2Q9

    # Number of dimensions
    D = 2
    # Number of distribution functions
    Q = 9

    # Lattice velocities
    C = [ [0,0],
          [1,0],
          [0,1],
          [-1,0],
          [0,-1],
          [1,1],
          [-1,1],
          [-1,-1],
          [1,-1]   ]
       
    # Lattice weights
    T = [4.0/9.0,
         1.0/9.0,1.0/9.0,1.0/9.0,1.0/9.0,
         1.0/36.0,1.0/36.0,1.0/36.0,1.0/36.0]

    # Links opposite to a given direction
    Opposite = [0,3,4,1,2,7,8,5,6]

    # Compute the squared norm of a vector
    def norm2(u)
        u.inject(0) { |sum, el| sum+el*el }
    end

    # Compute the norm of a vector
    def norm(u)
        Math.sqrt(norm2(u))
    end

    # Compute an equilibrium distribution
    def equilibrium(i, rho, u)
        c_u = C[i][0]*u[0]+C[i][1]*u[1]
        rho*T[i]*( 1 + 3*c_u + 4.5*c_u**2 - 1.5*norm2(u) )
    end

end
end
